﻿/*
	VERSION:		1.5
	
	NOTE:
		Version 1.5 works differently from version 1.4.
		It no longer automatically stores a "sprite" property.
		And its main parameter is an array to add script features to.
		done() is no longer automatically erased after being called.
	
	PURPOSE:
		This runs blocks of code in sequence, as a chain-reaction.
		allowing for arbitrary delays and halts.
		This is simple but very powerful.
		
	USAGE:
		#include "scriptSystem.as"
		events = makeScriptSystem();
		
		events.push(function(){		trace("First event!");		events.nextEvent();		  });
		events.push(function(){		trace("Second event!");		  });
		
		events.runEvent(0);
		
	NOTE:
		A standard set of event functions can be defined,
		which makes it easier to use this because 
		they can automatically call nextEvent() afterwords.
		example:
			events.push(		talk( events, "Hello World!");		);
		A reference to the script system is passed to them,
		allowing them to resume the script when they're done.
		
	FUNCTIONS:
		done()		externally-defined function that's called when the script reaches its end.
		
	PROPERTIES:
		isDone		Indicates whether the script has already finished running.
*/
makeScriptSystem = function( existingArray )
{
	// create container
	var _this = (existingArray) ? existingArray : [];
	
	// variables
	_this.index = 0;				// current event index
	
	
	
	// ______________________________________________________________________________________________________
	// FUNCTIONS
	_this.runEvent = function( eventIndex )
	{
		var eventIndex = _this.index = (eventIndex!=undefined) ? eventIndex : 0;		// continue running events from this point
		_this[eventIndex].call();
		
		if(eventIndex == _this.length-1)
		{// if:  The last event was just called
			_this.isDone = true;		// script IS done
			_this.done();				// externally-defined  (used for:  wait for movement)
		}else{
			_this.isDone = false;		// script isn't done
		}
	}// runEvent()
	
	
	
	_this.nextEvent = function()
	{
		_this.runEvent(_this.index+1);		// this function also updates "index"
	}// nextEvent()
	// ______________________________________________________________________________________________________
	
	
	
	// return container
	return _this;
}// makeScriptSystem()